﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIRP.EFR.BO;
using VIRP.EFR.DAL;
using System.Reflection;

namespace VIRP.EFR.BLL
{
    public static partial class EfrManager
    {
        #region ANALYSIS_DETAIL

        public static ANALYSIS_DETAIL ANALYSIS_DETAIL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return ANALYSIS_DETAILManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<ANALYSIS_DETAIL> ANALYSIS_DETAIL_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return ANALYSIS_DETAILManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int ANALYSIS_DETAIL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, ANALYSIS_DETAIL objSave)
        {
            return ANALYSIS_DETAILManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean ANALYSIS_DETAIL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return ANALYSIS_DETAILManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region CLINICAL_DETAIL

        public static CLINICAL_DETAIL CLINICAL_DETAIL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return CLINICAL_DETAILManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<CLINICAL_DETAIL> CLINICAL_DETAIL_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return CLINICAL_DETAILManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int CLINICAL_DETAIL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, CLINICAL_DETAIL objSave)
        {
            return CLINICAL_DETAILManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean CLINICAL_DETAIL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return CLINICAL_DETAILManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region CONTACT_LOG

        public static CONTACT_LOG CONTACT_LOG_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return CONTACT_LOGManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<CONTACT_LOG> CONTACT_LOG_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return CONTACT_LOGManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int CONTACT_LOG_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, CONTACT_LOG objSave)
        {
            return CONTACT_LOGManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean CONTACT_LOG_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return CONTACT_LOGManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        //#region CROSS_REFERENCE_PATIENTID

        //public static CROSS_REFERENCE_PATIENTID CROSS_REFERENCE_PATIENTID_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return CROSS_REFERENCE_PATIENTIDManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<CROSS_REFERENCE_PATIENTID> CROSS_REFERENCE_PATIENTID_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return CROSS_REFERENCE_PATIENTIDManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int CROSS_REFERENCE_PATIENTID_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, CROSS_REFERENCE_PATIENTID objSave)
        //{
        //    return CROSS_REFERENCE_PATIENTIDManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean CROSS_REFERENCE_PATIENTID_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return CROSS_REFERENCE_PATIENTIDManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //#endregion

        #region DOD_FRAGMENT

        public static BO.DOD_FRAGMENT DOD_FRAGMENT_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return DOD_FRAGMENTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<BO.DOD_FRAGMENT> DOD_FRAGMENT_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return DOD_FRAGMENTManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int DOD_FRAGMENT_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, BO.DOD_FRAGMENT objSave)
        {
            return DOD_FRAGMENTManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean DOD_FRAGMENT_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return DOD_FRAGMENTManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region DoD_FRAGMENT_DATA_RECEIVELOG

        public static BO.DoD_FRAGMENT_DATA_RECEIVELOG DoD_FRAGMENT_DATA_RECEIVELOG_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return DoD_FRAGMENT_DATA_RECEIVELOGManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<BO.DoD_FRAGMENT_DATA_RECEIVELOG> DoD_FRAGMENT_DATA_RECEIVELOG_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return DoD_FRAGMENT_DATA_RECEIVELOGManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int DoD_FRAGMENT_DATA_RECEIVELOG_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, BO.DoD_FRAGMENT_DATA_RECEIVELOG objSave)
        {
            return DoD_FRAGMENT_DATA_RECEIVELOGManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean DoD_FRAGMENT_DATA_RECEIVELOG_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return DoD_FRAGMENT_DATA_RECEIVELOGManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region DOD_FRAGMENT_DETAIL

        public static BO.DOD_FRAGMENT_DETAIL DOD_FRAGMENT_DETAIL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return DOD_FRAGMENT_DETAILManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<BO.DOD_FRAGMENT_DETAIL> DOD_FRAGMENT_DETAIL_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return DOD_FRAGMENT_DETAILManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int DOD_FRAGMENT_DETAIL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, BO.DOD_FRAGMENT_DETAIL objSave)
        {
            return DOD_FRAGMENT_DETAILManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean DOD_FRAGMENT_DETAIL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return DOD_FRAGMENT_DETAILManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region DOD_FRAGMENT_LAB

        public static BO.DOD_FRAGMENT_LAB DOD_FRAGMENT_LAB_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return DOD_FRAGMENT_LABManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<BO.DOD_FRAGMENT_LAB> DOD_FRAGMENT_LAB_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return DOD_FRAGMENT_LABManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int DOD_FRAGMENT_LAB_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, BO.DOD_FRAGMENT_LAB objSave)
        {
            return DOD_FRAGMENT_LABManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean DOD_FRAGMENT_LAB_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return DOD_FRAGMENT_LABManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        //#region DOD_FRAGMENT_RAW_DATA

        //public static DOD_FRAGMENT_RAW_DATA DOD_FRAGMENT_RAW_DATA_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return DOD_FRAGMENT_RAW_DATAManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<DOD_FRAGMENT_RAW_DATA> DOD_FRAGMENT_RAW_DATA_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return DOD_FRAGMENT_RAW_DATAManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int DOD_FRAGMENT_RAW_DATA_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, DOD_FRAGMENT_RAW_DATA objSave)
        //{
        //    return DOD_FRAGMENT_RAW_DATAManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean DOD_FRAGMENT_RAW_DATA_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return DOD_FRAGMENT_RAW_DATAManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //#endregion

        #region EFR_ICD9_DIAG

        public static EFR_ICD9_DIAG EFR_ICD9_DIAG_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return EFR_ICD9_DIAGManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<EFR_ICD9_DIAG> EFR_ICD9_DIAG_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return EFR_ICD9_DIAGManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int EFR_ICD9_DIAG_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, EFR_ICD9_DIAG objSave)
        {
            return EFR_ICD9_DIAGManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean EFR_ICD9_DIAG_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return EFR_ICD9_DIAGManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region EFR_PATIENT

        public static EFR_PATIENT EFR_PATIENT_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return EFR_PATIENTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<EFR_PATIENT> EFR_PATIENT_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return EFR_PATIENTManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int EFR_PATIENT_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, EFR_PATIENT objSave)
        {
            return EFR_PATIENTManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean EFR_PATIENT_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return EFR_PATIENTManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region EHR_LAB_TEST

        public static EHR_LAB_TEST EHR_LAB_TEST_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return EHR_LAB_TESTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<EHR_LAB_TEST> EHR_LAB_TEST_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return EHR_LAB_TESTManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int EHR_LAB_TEST_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, EHR_LAB_TEST objSave)
        {
            return EHR_LAB_TESTManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean EHR_LAB_TEST_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return EHR_LAB_TESTManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region ELECTRONIC_HEALTH_RECORD

        public static ELECTRONIC_HEALTH_RECORD ELECTRONIC_HEALTH_RECORD_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return ELECTRONIC_HEALTH_RECORDManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<ELECTRONIC_HEALTH_RECORD> ELECTRONIC_HEALTH_RECORD_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return ELECTRONIC_HEALTH_RECORDManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int ELECTRONIC_HEALTH_RECORD_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, ELECTRONIC_HEALTH_RECORD objSave)
        {
            return ELECTRONIC_HEALTH_RECORDManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean ELECTRONIC_HEALTH_RECORD_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return ELECTRONIC_HEALTH_RECORDManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        //#region ETL_ICD9_Control_Table

        //public static ETL_ICD9_Control_Table ETL_ICD9_Control_Table_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return ETL_ICD9_Control_TableManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<ETL_ICD9_Control_Table> ETL_ICD9_Control_Table_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return ETL_ICD9_Control_TableManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int ETL_ICD9_Control_Table_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, ETL_ICD9_Control_Table objSave)
        //{
        //    return ETL_ICD9_Control_TableManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean ETL_ICD9_Control_Table_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return ETL_ICD9_Control_TableManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //#endregion

        #region FRAGMENT_ANALYSIS

        public static FRAGMENT_ANALYSIS FRAGMENT_ANALYSIS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return FRAGMENT_ANALYSISManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<FRAGMENT_ANALYSIS> FRAGMENT_ANALYSIS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return FRAGMENT_ANALYSISManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static List<FRAGMENT_ANALYSIS> FRAGMENT_ANALYSIS_GET_ALL_BY_ACTIVITY(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            return FRAGMENT_ANALYSISManager.GetItemsByActivity(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
        }

        public static int FRAGMENT_ANALYSIS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, FRAGMENT_ANALYSIS objSave)
        {
            return FRAGMENT_ANALYSISManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean FRAGMENT_ANALYSIS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return FRAGMENT_ANALYSISManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region FRAGMENT_COLLECTION

        public static FRAGMENT_COLLECTION FRAGMENT_COLLECTION_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return FRAGMENT_COLLECTIONManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<FRAGMENT_COLLECTION> FRAGMENT_COLLECTION_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return FRAGMENT_COLLECTIONManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int FRAGMENT_COLLECTION_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, FRAGMENT_COLLECTION objSave)
        {
            return FRAGMENT_COLLECTIONManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean FRAGMENT_COLLECTION_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return FRAGMENT_COLLECTIONManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region IMAGE_ANALYSIS

        public static IMAGE_ANALYSIS IMAGE_ANALYSIS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return IMAGE_ANALYSISManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<IMAGE_ANALYSIS> IMAGE_ANALYSIS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return IMAGE_ANALYSISManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int IMAGE_ANALYSIS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, IMAGE_ANALYSIS objSave)
        {
            return IMAGE_ANALYSISManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean IMAGE_ANALYSIS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return IMAGE_ANALYSISManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region INJURY_DETAIL

        public static INJURY_DETAIL INJURY_DETAIL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return INJURY_DETAILManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<INJURY_DETAIL> INJURY_DETAIL_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return INJURY_DETAILManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int INJURY_DETAIL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, INJURY_DETAIL objSave)
        {
            return INJURY_DETAILManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean INJURY_DETAIL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return INJURY_DETAILManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region INTERPRETATION_LETTER

        public static INTERPRETATION_LETTER INTERPRETATION_LETTER_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return INTERPRETATION_LETTERManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<INTERPRETATION_LETTER> INTERPRETATION_LETTER_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return INTERPRETATION_LETTERManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int INTERPRETATION_LETTER_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, INTERPRETATION_LETTER objSave)
        {
            return INTERPRETATION_LETTERManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean INTERPRETATION_LETTER_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return INTERPRETATION_LETTERManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region LAB_ORDER

        public static LAB_ORDER LAB_ORDER_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LAB_ORDERManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<LAB_ORDER> LAB_ORDER_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return LAB_ORDERManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static List<LAB_ORDER> LAB_ORDER_GET_ALL_BY_ACTIVITY(string CURRENT_USER, int CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            return LAB_ORDERManager.GetItemsByActivity(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
        }

        public static int LAB_ORDER_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, LAB_ORDER objSave)
        {
            return LAB_ORDERManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean LAB_ORDER_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LAB_ORDERManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region LAB_ORDER_DETAIL

        public static LAB_ORDER_DETAIL LAB_ORDER_DETAIL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LAB_ORDER_DETAILManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<LAB_ORDER_DETAIL> LAB_ORDER_DETAIL_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return LAB_ORDER_DETAILManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int LAB_ORDER_DETAIL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, LAB_ORDER_DETAIL objSave)
        {
            return LAB_ORDER_DETAILManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean LAB_ORDER_DETAIL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LAB_ORDER_DETAILManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        //#region LAB_ORDER_STATIC

        //public static LAB_ORDER_STATIC LAB_ORDER_STATIC_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return LAB_ORDER_STATICManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<LAB_ORDER_STATIC> LAB_ORDER_STATIC_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return LAB_ORDER_STATICManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int LAB_ORDER_STATIC_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, LAB_ORDER_STATIC objSave)
        //{
        //    return LAB_ORDER_STATICManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean LAB_ORDER_STATIC_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return LAB_ORDER_STATICManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //#endregion

        #region LABRESULT_CHANGE_TRACKING

        public static LABRESULT_CHANGE_TRACKING LABRESULT_CHANGE_TRACKING_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LABRESULT_CHANGE_TRACKINGManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<LABRESULT_CHANGE_TRACKING> LABRESULT_CHANGE_TRACKING_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return LABRESULT_CHANGE_TRACKINGManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int LABRESULT_CHANGE_TRACKING_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, LABRESULT_CHANGE_TRACKING objSave)
        {
            return LABRESULT_CHANGE_TRACKINGManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean LABRESULT_CHANGE_TRACKING_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LABRESULT_CHANGE_TRACKINGManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region LETTER_BATCH_PRINTING_STATUS

        public static LETTER_BATCH_PRINTING_STATUS LETTER_BATCH_PRINTING_STATUS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LETTER_BATCH_PRINTING_STATUSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<LETTER_BATCH_PRINTING_STATUS> LETTER_BATCH_PRINTING_STATUS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return LETTER_BATCH_PRINTING_STATUSManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int LETTER_BATCH_PRINTING_STATUS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, LETTER_BATCH_PRINTING_STATUS objSave)
        {
            return LETTER_BATCH_PRINTING_STATUSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean LETTER_BATCH_PRINTING_STATUS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LETTER_BATCH_PRINTING_STATUSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region LETTER_TEMPLATE

        public static LETTER_TEMPLATE LETTER_TEMPLATE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LETTER_TEMPLATEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<LETTER_TEMPLATE> LETTER_TEMPLATE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return LETTER_TEMPLATEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int LETTER_TEMPLATE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, LETTER_TEMPLATE objSave)
        {
            return LETTER_TEMPLATEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean LETTER_TEMPLATE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return LETTER_TEMPLATEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region MAILING

        public static MAILING MAILING_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return MAILINGManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<MAILING> MAILING_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return MAILINGManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int MAILING_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, MAILING objSave)
        {
            return MAILINGManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean MAILING_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return MAILINGManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region Patient_Ext

        public static Patient_Ext Patient_Ext_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return Patient_ExtManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<Patient_Ext> Patient_Ext_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return Patient_ExtManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int Patient_Ext_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, Patient_Ext objSave)
        {
            return Patient_ExtManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean Patient_Ext_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return Patient_ExtManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region PATIENT_IMAGE

        //public static PATIENT_IMAGE PATIENT_IMAGE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return PATIENT_IMAGEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<PATIENT_IMAGE> PATIENT_IMAGE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return PATIENT_IMAGEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int PATIENT_IMAGE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, PATIENT_IMAGE objSave)
        //{
        //    return PATIENT_IMAGEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean PATIENT_IMAGE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return PATIENT_IMAGEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        #endregion

        #region PATIENT_IMAGE_BODY_PART

        //public static PATIENT_IMAGE_BODY_PART PATIENT_IMAGE_BODY_PART_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return PATIENT_IMAGE_BODY_PARTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<PATIENT_IMAGE_BODY_PART> PATIENT_IMAGE_BODY_PART_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return PATIENT_IMAGE_BODY_PARTManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int PATIENT_IMAGE_BODY_PART_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, PATIENT_IMAGE_BODY_PART objSave)
        //{
        //    return PATIENT_IMAGE_BODY_PARTManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean PATIENT_IMAGE_BODY_PART_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return PATIENT_IMAGE_BODY_PARTManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        #endregion

        #region PATIENT_IMAGE_REASON

        //public static PATIENT_IMAGE_REASON PATIENT_IMAGE_REASON_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return PATIENT_IMAGE_REASONManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<PATIENT_IMAGE_REASON> PATIENT_IMAGE_REASON_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return PATIENT_IMAGE_REASONManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int PATIENT_IMAGE_REASON_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, PATIENT_IMAGE_REASON objSave)
        //{
        //    return PATIENT_IMAGE_REASONManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean PATIENT_IMAGE_REASON_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return PATIENT_IMAGE_REASONManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        #endregion

        #region PATIENT_IMAGE_REVIEW

        //public static PATIENT_IMAGE_REVIEW PATIENT_IMAGE_REVIEW_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return PATIENT_IMAGE_REVIEWManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<PATIENT_IMAGE_REVIEW> PATIENT_IMAGE_REVIEW_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return PATIENT_IMAGE_REVIEWManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int PATIENT_IMAGE_REVIEW_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, PATIENT_IMAGE_REVIEW objSave)
        //{
        //    return PATIENT_IMAGE_REVIEWManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean PATIENT_IMAGE_REVIEW_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return PATIENT_IMAGE_REVIEWManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        #endregion

        #region QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT

        public static QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT> QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT objSave)
        {
            return QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM

        public static QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM> QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM objSave)
        {
            return QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region QUES_STD_SERVICEBRANCH

        public static QUES_STD_SERVICEBRANCH QUES_STD_SERVICEBRANCH_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return QUES_STD_SERVICEBRANCHManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<QUES_STD_SERVICEBRANCH> QUES_STD_SERVICEBRANCH_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return QUES_STD_SERVICEBRANCHManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int QUES_STD_SERVICEBRANCH_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, QUES_STD_SERVICEBRANCH objSave)
        {
            return QUES_STD_SERVICEBRANCHManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean QUES_STD_SERVICEBRANCH_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return QUES_STD_SERVICEBRANCHManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region QUES_STD_VAMC

        public static QUES_STD_VAMC QUES_STD_VAMC_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return QUES_STD_VAMCManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<QUES_STD_VAMC> QUES_STD_VAMC_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return QUES_STD_VAMCManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int QUES_STD_VAMC_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, QUES_STD_VAMC objSave)
        {
            return QUES_STD_VAMCManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean QUES_STD_VAMC_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return QUES_STD_VAMCManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        //#region REFERRAL

        //public static REFERRAL REFERRAL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return REFERRALManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<REFERRAL> REFERRAL_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return REFERRALManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int REFERRAL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, REFERRAL objSave)
        //{
        //    return REFERRALManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean REFERRAL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return REFERRALManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //#endregion

        #region REFERRAL_ORIGINAL

        public static REFERRAL_ORIGINAL REFERRAL_ORIGINAL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return REFERRAL_ORIGINALManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<REFERRAL_ORIGINAL> REFERRAL_ORIGINAL_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return REFERRAL_ORIGINALManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int REFERRAL_ORIGINAL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, REFERRAL_ORIGINAL objSave)
        {
            return REFERRAL_ORIGINALManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean REFERRAL_ORIGINAL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return REFERRAL_ORIGINALManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region RELATED_LAB_TEST

        public static RELATED_LAB_TEST RELATED_LAB_TEST_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return RELATED_LAB_TESTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<RELATED_LAB_TEST> RELATED_LAB_TEST_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return RELATED_LAB_TESTManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int RELATED_LAB_TEST_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, RELATED_LAB_TEST objSave)
        {
            return RELATED_LAB_TESTManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean RELATED_LAB_TEST_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return RELATED_LAB_TESTManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region SHIPPING_DETAIL

        public static SHIPPING_DETAIL SHIPPING_DETAIL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return SHIPPING_DETAILManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<SHIPPING_DETAIL> SHIPPING_DETAIL_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return SHIPPING_DETAILManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int SHIPPING_DETAIL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, SHIPPING_DETAIL objSave)
        {
            return SHIPPING_DETAILManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean SHIPPING_DETAIL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return SHIPPING_DETAILManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region SPECIMEN_ANALYSIS

        public static SPECIMEN_ANALYSIS SPECIMEN_ANALYSIS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return SPECIMEN_ANALYSISManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<SPECIMEN_ANALYSIS> SPECIMEN_ANALYSIS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return SPECIMEN_ANALYSISManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int SPECIMEN_ANALYSIS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, SPECIMEN_ANALYSIS objSave)
        {
            return SPECIMEN_ANALYSISManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean SPECIMEN_ANALYSIS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return SPECIMEN_ANALYSISManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_ANALYSISMETHOD

        public static STD_ANALYSISMETHOD STD_ANALYSISMETHOD_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ANALYSISMETHODManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_ANALYSISMETHOD> STD_ANALYSISMETHOD_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_ANALYSISMETHODManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_ANALYSISMETHOD_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_ANALYSISMETHOD objSave)
        {
            return STD_ANALYSISMETHODManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_ANALYSISMETHOD_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ANALYSISMETHODManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        //#region STD_ANALYTE_TEST_REFERENCE_RANGE

        //public static STD_ANALYTE_TEST_REFERENCE_RANGE STD_ANALYTE_TEST_REFERENCE_RANGE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return STD_ANALYTE_TEST_REFERENCE_RANGEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<STD_ANALYTE_TEST_REFERENCE_RANGE> STD_ANALYTE_TEST_REFERENCE_RANGE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return STD_ANALYTE_TEST_REFERENCE_RANGEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int STD_ANALYTE_TEST_REFERENCE_RANGE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_ANALYTE_TEST_REFERENCE_RANGE objSave)
        //{
        //    return STD_ANALYTE_TEST_REFERENCE_RANGEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean STD_ANALYTE_TEST_REFERENCE_RANGE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return STD_ANALYTE_TEST_REFERENCE_RANGEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //#endregion

        #region STD_ANALYTETYPE

        public static VIRP.EFR.BO.STD_ANALYTETYPE STD_ANALYTETYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ANALYTETYPEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<VIRP.EFR.BO.STD_ANALYTETYPE> STD_ANALYTETYPE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_ANALYTETYPEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_ANALYTETYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, VIRP.EFR.BO.STD_ANALYTETYPE objSave)
        {
            return STD_ANALYTETYPEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_ANALYTETYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ANALYTETYPEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_ANALYTETYPE_All

        public static STD_ANALYTETYPE_All STD_ANALYTETYPE_All_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ANALYTETYPE_AllManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_ANALYTETYPE_All> STD_ANALYTETYPE_All_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_ANALYTETYPE_AllManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_ANALYTETYPE_All_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_ANALYTETYPE_All objSave)
        {
            return STD_ANALYTETYPE_AllManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_ANALYTETYPE_All_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ANALYTETYPE_AllManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_DURATION

        public static STD_DURATION STD_DURATION_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_DURATIONManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_DURATION> STD_DURATION_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_DURATIONManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_DURATION_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_DURATION objSave)
        {
            return STD_DURATIONManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_DURATION_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_DURATIONManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_EMBEDDED_FRAGMENT_INDICATORS

        public static STD_EMBEDDED_FRAGMENT_INDICATORS STD_EMBEDDED_FRAGMENT_INDICATORS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_EMBEDDED_FRAGMENT_INDICATORSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_EMBEDDED_FRAGMENT_INDICATORS> STD_EMBEDDED_FRAGMENT_INDICATORS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_EMBEDDED_FRAGMENT_INDICATORSManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_EMBEDDED_FRAGMENT_INDICATORS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_EMBEDDED_FRAGMENT_INDICATORS objSave)
        {
            return STD_EMBEDDED_FRAGMENT_INDICATORSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_EMBEDDED_FRAGMENT_INDICATORS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_EMBEDDED_FRAGMENT_INDICATORSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_FRAGMENT_ANALYSIS_TYPE

        public static BO.STD_FRAGMENT_ANALYSIS_TYPE STD_FRAGMENT_ANALYSIS_TYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_FRAGMENT_ANALYSIS_TYPEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<BO.STD_FRAGMENT_ANALYSIS_TYPE> STD_FRAGMENT_ANALYSIS_TYPE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_FRAGMENT_ANALYSIS_TYPEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_FRAGMENT_ANALYSIS_TYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, BO.STD_FRAGMENT_ANALYSIS_TYPE objSave)
        {
            return STD_FRAGMENT_ANALYSIS_TYPEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_FRAGMENT_ANALYSIS_TYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_FRAGMENT_ANALYSIS_TYPEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_ICD9

        public static STD_ICD9 STD_ICD9_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ICD9Manager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_ICD9> STD_ICD9_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_ICD9Manager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_ICD9_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_ICD9 objSave)
        {
            return STD_ICD9Manager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_ICD9_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ICD9Manager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_IMAGE_BODY_PART

        public static STD_IMAGE_BODY_PART STD_IMAGE_BODY_PART_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_BODY_PARTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_IMAGE_BODY_PART> STD_IMAGE_BODY_PART_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_IMAGE_BODY_PARTManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_IMAGE_BODY_PART_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_IMAGE_BODY_PART objSave)
        {
            return STD_IMAGE_BODY_PARTManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_IMAGE_BODY_PART_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_BODY_PARTManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_IMAGE_FRAGMENT_COUNT

        public static STD_IMAGE_FRAGMENT_COUNT STD_IMAGE_FRAGMENT_COUNT_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_FRAGMENT_COUNTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_IMAGE_FRAGMENT_COUNT> STD_IMAGE_FRAGMENT_COUNT_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_IMAGE_FRAGMENT_COUNTManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_IMAGE_FRAGMENT_COUNT_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_IMAGE_FRAGMENT_COUNT objSave)
        {
            return STD_IMAGE_FRAGMENT_COUNTManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_IMAGE_FRAGMENT_COUNT_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_FRAGMENT_COUNTManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_IMAGE_FRAGMENT_SIZE

        public static STD_IMAGE_FRAGMENT_SIZE STD_IMAGE_FRAGMENT_SIZE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_FRAGMENT_SIZEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_IMAGE_FRAGMENT_SIZE> STD_IMAGE_FRAGMENT_SIZE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_IMAGE_FRAGMENT_SIZEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_IMAGE_FRAGMENT_SIZE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_IMAGE_FRAGMENT_SIZE objSave)
        {
            return STD_IMAGE_FRAGMENT_SIZEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_IMAGE_FRAGMENT_SIZE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_FRAGMENT_SIZEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_IMAGE_REASON

        public static STD_IMAGE_REASON STD_IMAGE_REASON_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_REASONManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_IMAGE_REASON> STD_IMAGE_REASON_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_IMAGE_REASONManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_IMAGE_REASON_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_IMAGE_REASON objSave)
        {
            return STD_IMAGE_REASONManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_IMAGE_REASON_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_REASONManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_IMAGE_TYPE

        public static STD_IMAGE_TYPE STD_IMAGE_TYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_TYPEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_IMAGE_TYPE> STD_IMAGE_TYPE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_IMAGE_TYPEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_IMAGE_TYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_IMAGE_TYPE objSave)
        {
            return STD_IMAGE_TYPEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_IMAGE_TYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_IMAGE_TYPEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_LETTERTYPE

        public static STD_LETTERTYPE STD_LETTERTYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_LETTERTYPEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_LETTERTYPE> STD_LETTERTYPE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_LETTERTYPEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_LETTERTYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_LETTERTYPE objSave)
        {
            return STD_LETTERTYPEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_LETTERTYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_LETTERTYPEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_MESSAGESTS

        public static STD_MESSAGESTS STD_MESSAGESTS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_MESSAGESTSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_MESSAGESTS> STD_MESSAGESTS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_MESSAGESTSManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_MESSAGESTS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_MESSAGESTS objSave)
        {
            return STD_MESSAGESTSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_MESSAGESTS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_MESSAGESTSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_MESSAGETYPE

        public static STD_MESSAGETYPE STD_MESSAGETYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_MESSAGETYPEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_MESSAGETYPE> STD_MESSAGETYPE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_MESSAGETYPEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_MESSAGETYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_MESSAGETYPE objSave)
        {
            return STD_MESSAGETYPEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_MESSAGETYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_MESSAGETYPEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_MILITARYDUTYSTS

        public static STD_MILITARYDUTYSTS STD_MILITARYDUTYSTS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_MILITARYDUTYSTSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_MILITARYDUTYSTS> STD_MILITARYDUTYSTS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_MILITARYDUTYSTSManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_MILITARYDUTYSTS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_MILITARYDUTYSTS objSave)
        {
            return STD_MILITARYDUTYSTSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_MILITARYDUTYSTS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_MILITARYDUTYSTSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_ORDERSTS

        public static STD_ORDERSTS STD_ORDERSTS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ORDERSTSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_ORDERSTS> STD_ORDERSTS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_ORDERSTSManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_ORDERSTS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_ORDERSTS objSave)
        {
            return STD_ORDERSTSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_ORDERSTS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ORDERSTSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_SHIPMENTSTS

        public static STD_SHIPMENTSTS STD_SHIPMENTSTS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SHIPMENTSTSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_SHIPMENTSTS> STD_SHIPMENTSTS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_SHIPMENTSTSManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_SHIPMENTSTS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_SHIPMENTSTS objSave)
        {
            return STD_SHIPMENTSTSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_SHIPMENTSTS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SHIPMENTSTSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_SHIPMENTTYPE

        public static STD_SHIPMENTTYPE STD_SHIPMENTTYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SHIPMENTTYPEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_SHIPMENTTYPE> STD_SHIPMENTTYPE_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_SHIPMENTTYPEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_SHIPMENTTYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_SHIPMENTTYPE objSave)
        {
            return STD_SHIPMENTTYPEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_SHIPMENTTYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SHIPMENTTYPEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_SHIPMETHOD

        public static STD_SHIPMETHOD STD_SHIPMETHOD_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SHIPMETHODManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_SHIPMETHOD> STD_SHIPMETHOD_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_SHIPMETHODManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_SHIPMETHOD_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_SHIPMETHOD objSave)
        {
            return STD_SHIPMETHODManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_SHIPMETHOD_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SHIPMETHODManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_SOAP

        public static STD_SOAP STD_SOAP_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SOAPManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_SOAP> STD_SOAP_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_SOAPManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_SOAP_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_SOAP objSave)
        {
            return STD_SOAPManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_SOAP_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SOAPManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_TEST_NAME

        public static VIRP.EFR.BO.STD_TEST_NAME STD_TEST_NAME_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_TEST_NAMEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<VIRP.EFR.BO.STD_TEST_NAME> STD_TEST_NAME_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_TEST_NAMEManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_TEST_NAME_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, VIRP.EFR.BO.STD_TEST_NAME objSave)
        {
            return STD_TEST_NAMEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_TEST_NAME_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_TEST_NAMEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_UNITS

        public static STD_UNITS STD_UNITS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_UNITSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_UNITS> STD_UNITS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_UNITSManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_UNITS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_UNITS objSave)
        {
            return STD_UNITSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_UNITS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_UNITSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        //#region SystemParameters

        //public static SystemParameters SystemParameters_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return SystemParametersManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<SystemParameters> SystemParameters_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return SystemParametersManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int SystemParameters_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, SystemParameters objSave)
        //{
        //    return SystemParametersManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean SystemParameters_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return SystemParametersManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //#endregion

        #region TMDS_FTP_Log

        public static TMDS_FTP_Log TMDS_FTP_Log_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return TMDS_FTP_LogManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<TMDS_FTP_Log> TMDS_FTP_Log_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return TMDS_FTP_LogManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int TMDS_FTP_Log_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, TMDS_FTP_Log objSave)
        {
            return TMDS_FTP_LogManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean TMDS_FTP_Log_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return TMDS_FTP_LogManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region TMDS_PATIENT

        public static TMDS_PATIENT TMDS_PATIENT_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return TMDS_PATIENTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<TMDS_PATIENT> TMDS_PATIENT_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return TMDS_PATIENTManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int TMDS_PATIENT_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, TMDS_PATIENT objSave)
        {
            return TMDS_PATIENTManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean TMDS_PATIENT_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return TMDS_PATIENTManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region TMDS_PATIENT_ICD

        public static TMDS_PATIENT_ICD TMDS_PATIENT_ICD_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return TMDS_PATIENT_ICDManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<TMDS_PATIENT_ICD> TMDS_PATIENT_ICD_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return TMDS_PATIENT_ICDManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int TMDS_PATIENT_ICD_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, TMDS_PATIENT_ICD objSave)
        {
            return TMDS_PATIENT_ICDManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean TMDS_PATIENT_ICD_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return TMDS_PATIENT_ICDManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region TMDS_PATIENT_SOAP_KEYWORD

        public static TMDS_PATIENT_SOAP_KEYWORD TMDS_PATIENT_SOAP_KEYWORD_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return TMDS_PATIENT_SOAP_KEYWORDManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<TMDS_PATIENT_SOAP_KEYWORD> TMDS_PATIENT_SOAP_KEYWORD_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return TMDS_PATIENT_SOAP_KEYWORDManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int TMDS_PATIENT_SOAP_KEYWORD_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, TMDS_PATIENT_SOAP_KEYWORD objSave)
        {
            return TMDS_PATIENT_SOAP_KEYWORDManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean TMDS_PATIENT_SOAP_KEYWORD_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return TMDS_PATIENT_SOAP_KEYWORDManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        //#region TMDS_Staging

        //public static TMDS_Staging TMDS_Staging_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return TMDS_StagingManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //public static List<TMDS_Staging> TMDS_Staging_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        //{
        //    return TMDS_StagingManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        //}

        //public static int TMDS_Staging_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, TMDS_Staging objSave)
        //{
        //    return TMDS_StagingManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        //}

        //public static Boolean TMDS_Staging_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        //{
        //    return TMDS_StagingManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        //}

        //#endregion

        #region Unique_Screened_Individual

        public static Unique_Screened_Individual Unique_Screened_Individual_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return Unique_Screened_IndividualManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<Unique_Screened_Individual> Unique_Screened_Individual_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return Unique_Screened_IndividualManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int Unique_Screened_Individual_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, Unique_Screened_Individual objSave)
        {
            return Unique_Screened_IndividualManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean Unique_Screened_Individual_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return Unique_Screened_IndividualManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region VISTA_IMAGING_SERVICES_CONFIGURATION

        public static VISTA_IMAGING_SERVICES_CONFIGURATION VISTA_IMAGING_SERVICES_CONFIGURATION_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return VISTA_IMAGING_SERVICES_CONFIGURATIONManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<VISTA_IMAGING_SERVICES_CONFIGURATION> VISTA_IMAGING_SERVICES_CONFIGURATION_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return VISTA_IMAGING_SERVICES_CONFIGURATIONManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int VISTA_IMAGING_SERVICES_CONFIGURATION_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, VISTA_IMAGING_SERVICES_CONFIGURATION objSave)
        {
            return VISTA_IMAGING_SERVICES_CONFIGURATIONManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean VISTA_IMAGING_SERVICES_CONFIGURATION_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return VISTA_IMAGING_SERVICES_CONFIGURATIONManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region VTA_PATIENT

        public static VTA_PATIENT VTA_PATIENT_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return VTA_PATIENTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<VTA_PATIENT> VTA_PATIENT_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return VTA_PATIENTManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int VTA_PATIENT_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, VTA_PATIENT objSave)
        {
            return VTA_PATIENTManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean VTA_PATIENT_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return VTA_PATIENTManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region VTA_PATIENT_ICD9

        public static VTA_PATIENT_ICD9 VTA_PATIENT_ICD9_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return VTA_PATIENT_ICD9Manager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<VTA_PATIENT_ICD9> VTA_PATIENT_ICD9_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return VTA_PATIENT_ICD9Manager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int VTA_PATIENT_ICD9_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, VTA_PATIENT_ICD9 objSave)
        {
            return VTA_PATIENT_ICD9Manager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean VTA_PATIENT_ICD9_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return VTA_PATIENT_ICD9Manager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region VTA_PATIENT_SOAP_KEYWORD

        public static VTA_PATIENT_SOAP_KEYWORD VTA_PATIENT_SOAP_KEYWORD_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return VTA_PATIENT_SOAP_KEYWORDManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<VTA_PATIENT_SOAP_KEYWORD> VTA_PATIENT_SOAP_KEYWORD_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return VTA_PATIENT_SOAP_KEYWORDManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int VTA_PATIENT_SOAP_KEYWORD_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, VTA_PATIENT_SOAP_KEYWORD objSave)
        {
            return VTA_PATIENT_SOAP_KEYWORDManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean VTA_PATIENT_SOAP_KEYWORD_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return VTA_PATIENT_SOAP_KEYWORDManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion
    }
}